/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.fmt;

import com.quantumdata.fmteditor.fmt.CmdValueListener;
import com.quantumdata.fmteditor.fmt.CmdValueType;
import com.quantumdata.fmteditor.fmtwidgets.NamedValue;
import java.util.Vector;

public class CmdValue {
    private String m_name = "";
    private String m_cmd = "";
    private CmdValueType m_type = CmdValueType.UNDEFINED;
    private String m_description = "";
    private double m_value = 0.0;
    private double m_initialValue = 0.0;
    private int m_base = 10;
    private boolean m_isObsolete = false;
    private NamedValue[] m_enumValues = null;
    private Vector<CmdValueListener> m_listeners = null;
    private boolean m_derived = false;

    public CmdValue() {
    }

    public CmdValue(CmdValueType cmdValueType, String string, double d, String string2) {
        this(cmdValueType, string, d, false, null, string2);
    }

    public CmdValue(CmdValueType cmdValueType, String string, double d, NamedValue[] namedValueArray, String string2) {
        this(cmdValueType, string, d, false, namedValueArray, string2);
    }

    public CmdValue(CmdValueType cmdValueType, String string, double d, boolean bl, String string2) {
        this(cmdValueType, string, d, bl, null, string2);
    }

    public CmdValue(CmdValueType cmdValueType, String string, double d, boolean bl, NamedValue[] namedValueArray, String string2) {
        this.m_name = this.m_cmd = string;
        this.m_type = cmdValueType;
        this.m_description = string2;
        this.m_initialValue = this.m_value = d;
        this.m_isObsolete = bl;
        this.m_enumValues = namedValueArray;
    }

    public CmdValue(String string, CmdValueType cmdValueType, String string2, double d, String string3) {
        this(cmdValueType, string2, d, false, string3);
        this.m_name = string;
    }

    public CmdValue clone() {
        CmdValue cmdValue = new CmdValue(this.m_name, this.m_type, this.m_cmd, this.m_value, this.m_description);
        cmdValue.m_isObsolete = this.m_isObsolete;
        cmdValue.m_enumValues = this.m_enumValues;
        cmdValue.m_derived = this.m_derived;
        cmdValue.m_initialValue = this.m_initialValue;
        return cmdValue;
    }

    public void addListener(CmdValueListener cmdValueListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector();
        }
        this.m_listeners.add(cmdValueListener);
    }

    public void removeListener(CmdValueListener cmdValueListener) {
        if (this.m_listeners == null) {
            return;
        }
        this.m_listeners.remove(cmdValueListener);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public String getCmd() {
        return this.m_cmd;
    }

    public void setCmd(String string) {
        this.m_cmd = string;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String string) {
        this.m_description = string;
    }

    public CmdValueType getType() {
        return this.m_type;
    }

    public void setType(CmdValueType cmdValueType) {
        this.m_type = cmdValueType;
    }

    public int getBase() {
        return this.m_base;
    }

    public void setBase(int n) {
        this.m_base = n;
    }

    public boolean isObsolete() {
        return this.m_isObsolete;
    }

    public void setObsolete(boolean bl) {
        this.m_isObsolete = bl;
    }

    public boolean isDerived() {
        return this.m_derived;
    }

    public void setDerived(boolean bl) {
        this.m_derived = bl;
    }

    public boolean isEnum() {
        return this.m_enumValues != null;
    }

    public void setEnumValues(NamedValue[] namedValueArray) {
        this.m_enumValues = namedValueArray;
    }

    public NamedValue[] getEnumValues() {
        return this.m_enumValues;
    }

    public String getEnumName() {
        if (!this.isEnum()) {
            return "";
        }
        int n = this.getInt();
        for (NamedValue namedValue : this.m_enumValues) {
            if (namedValue.value() != n) continue;
            return namedValue.name();
        }
        return "";
    }

    public boolean isModified() {
        return this.m_value != this.m_initialValue;
    }

    public void markUnmodified() {
        this.m_initialValue = this.m_value;
    }

    public int getInt() {
        return (int)Math.round(this.m_value);
    }

    public double getDouble() {
        return this.m_value;
    }

    public boolean getBool() {
        return this.getInt() == 1;
    }

    public void setInt(int n) {
        this.m_value = n;
        this.emmitValueChanged();
    }

    public void setDouble(double d) {
        this.m_value = d;
        this.emmitValueChanged();
    }

    public void setDoubleQuite(double d) {
        this.m_value = d;
    }

    public void setBool(boolean bl) {
        this.m_value = bl ? 1.0 : 0.0;
        this.emmitValueChanged();
    }

    public boolean set(String string) {
        if (string.length() == 0) {
            this.m_value = 0.0;
            this.emmitValueChanged();
            return true;
        }
        try {
            switch (this.m_type) {
                case INT: {
                    this.m_value = Integer.parseInt(string, this.m_base);
                    break;
                }
                case DOUBLE: {
                    this.m_value = Double.parseDouble(string);
                    break;
                }
                case BOOL: {
                    if (Character.isDigit(string.charAt(0))) {
                        this.m_value = Integer.parseInt(string, 10) == 1 ? 1.0 : 0.0;
                        break;
                    }
                    this.m_value = 0.0;
                    if (string.equalsIgnoreCase("true")) {
                        this.m_value = 1.0;
                    }
                    break;
                }
                default: {
                    return true;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        this.emmitValueChanged();
        return true;
    }

    public String get() {
        String string = "";
        block0 : switch (this.m_type) {
            case INT: {
                switch (this.m_base) {
                    case 16: {
                        string = Integer.toHexString(this.getInt());
                        break block0;
                    }
                }
                string = Integer.toString(this.getInt());
                break;
            }
            case DOUBLE: {
                string = Double.toString(this.m_value);
                break;
            }
            case BOOL: {
                string = this.getBool() ? "1" : "0";
            }
        }
        return string;
    }

    private void emmitValueChanged() {
        if (this.m_listeners != null) {
            for (CmdValueListener cmdValueListener : this.m_listeners) {
                cmdValueListener.valueChanged(this);
            }
        }
    }
}

